IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO]')) 
	begin
		return;
	end
else
begin
CREATE TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[CD_NF_ENT] [int] NOT NULL,
 CONSTRAINT [PK_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC,
	[CD_NF_ENT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO] ADD  CONSTRAINT [DF_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO_CD_NF_ENT]  DEFAULT ((0)) FOR [CD_NF_ENT]

ALTER TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO_EST_NF_ENT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF_ENT])
REFERENCES [dbo].[EST_NF_ENT] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO] CHECK CONSTRAINT [FK_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO_EST_NF_ENT]

ALTER TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[EST_NF_SAI_EST_NF_ENT_ADJUDICACAO] CHECK CONSTRAINT [FK_EST_NF_SAI_EST_NF_ENT_ADJUDICACAO_EST_NF_SAI]
end